<%-- Copyright (c) Oracle Corporation 2002. All Rights Reserved. --%>

<%--
    NAME
        PhotoAlbumEntryViewer.jsp

    DESCRIPTION
        PhotoAlbumEntryViewer.jsp is one component of a JavaServer Pages
        application that demonstrates the use of Oracle Multimedia Java 
        Classes for Servlets and JSPs by implementing a simple photo album 
        application. This page displays a single entry from the album with 
        the full-size version of the photo. This page uses the PhotoAlbumBean 
        JavaBean to access the database.

    NOTES
        See the README.txt file for information on how to build and
        run the demo.
--%>

<%@ page language="java" %>
<%@ page import="imjspdemo.PhotoAlbumBean" %>
<%@ page import="oracle.ord.im.OrdHttpJspResponseHandler" %>

<jsp:useBean id="album" scope="page" class="imjspdemo.PhotoAlbumBean"/>
<jsp:useBean id="handler" scope="page"
             class="oracle.ord.im.OrdHttpJspResponseHandler"/>

<%-- HTML header --%>
<html lang="EN">
<head>
<title>Oracle Multimedia JavaServer Pages Photo Album Demo</title>
</head>

<body>

<%-- Page heading --%>
<table border="0" width="100%">
  <tr>
    <td colspan="2" bgcolor="#f7f7e7" align="center"><font size="+2">
      Oracle Multimedia JavaServer Pages Photo Album Demo</font>
    </td>
  </tr>
</table>

<%-- Make sure the entry ID was specified --%>
<%
    String id = request.getParameter( "id" );
    if ( id == null )
    {
%>
        <p>Malformed URL, no id parameter!!!!</p>
<%
        return;
    }

    //
    // Use a try block to ensure the JDBC connection is released.
    //
    try
    {
        //
        // Select the entry to be displayed
        //
        album.selectRowById( id );
        if ( !album.fetch() )
        {
%>
            <p>Entry not found: <%= id %>!!!!</p>
<%
            return;
        }
%>

    <%-- Display the entry in the album --%>
    <table summary="View image entry">
      <tr>
        <td scope="col" ><b>Description:</b></td>
        <td scope="col" >
          <%= PhotoAlbumBean.escapeHtmlString(album.getDescription()) %></td>
      </tr>
      <tr>
        <td scope="col" ><b>Location:</b></td>
<%
        if ( album.getLocation() != null )
        {
            out.print( "<td scope=\"col\" >" + 
              PhotoAlbumBean.escapeHtmlString(album.getLocation()) + 
              "</td>" );
        }
        else
        {
            out.print( "<td scope=\"col\" >&nbsp;</td>" );
        }
%>
      </tr>
      <tr>
        <td scope="col" valign="top"><b>Photo:</b></td>
        <td scope="col" >
<%
          //
          // If the image format isn't recognized by Oracle Multimedia, 
          // then the height and width attributes will be 0, so don't 
          // generate the corresponding image tag attributes.
          //
          if (album.getImage().getMimeType().startsWith("image/")) 
          {
              out.print( "<img src=\"PhotoAlbumMediaViewer.jsp" +
                         "?media=image" +
                         "&id=" + album.getId() + "\"" );
              if ( album.getImage().getHeight() > 0 &&
                   album.getImage().getWidth() > 0 )
              {
                  out.print("height=\""+album.getImage().getHeight() + "\"" );
                  out.print("width=\"" + album.getImage().getWidth() + "\"" );
              }
              out.print( "alt=\"" + 
                PhotoAlbumBean.escapeHtmlString(album.getDescription())+"\"" );
              out.print( "border=\"1\">" );
         }
         else
         {// non-image data...
             out.print ("<A HREF=\"PhotoAlbumMediaViewer.jsp" +
		        "?media=image&id=" + id + "\">" +
                        "View non-Image Media (" +
                        album.getImage().getMimeType() + ")</A>" );
         }
%>
        </td>
      </tr>
    </table>

    <%-- Output a link to return to the main page --%>
    <p>
    <table width="100%">
      <tr bgcolor="#f7f7e7">
        <td colspan="3" align="center">
          <a href="PhotoAlbum.jsp">Return to photo album</a>
        </td>
      </tr>
    </table>
    </p>
<%
    }
    finally
    {
        //
        // Ensure the JDBC connection is released
        //
        album.release();
    }
%>

<%-- Finish the page --%>
</body>
</html>

